<?php $__env->startSection('title', __($module_title)); ?>

<?php $__env->startPush('after-styles'); ?>
    <link rel="stylesheet" href="<?php echo e(mix('modules/constant/style.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="card mb-4">
    <div class="card-body p-0">
        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped border notification-table">
                        <thead>
                            <tr>
                                <th><?php echo e(__('notification.lbl_id')); ?></th>
                                <th><?php echo e(__('notification.type')); ?></th>
                                <th><?php echo e(__('notification.lbl_text')); ?></th>
                                <th><?php echo e(__('notification.lbl_customer')); ?></th>
                                <th><?php echo e(__('notification.lbl_update')); ?></th>
                                <th><?php echo e(__('notification.lbl_action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $counter = 1; ?>
                            <?php $__empty_1 = true; $__currentLoopData = $$module_name; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module_name_singular): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $row_class = '';
                                    $span_class = '';
                                    if ($module_name_singular->read_at == '') {
                                        $row_class = 'table-info';
                                        $span_class = 'font-weight-bold';
                                    }
                                ?>

                                <input type="hidden" id="idData" value="<?php echo e($module_name_singular->id); ?>">

                                <tr class="<?php echo e($row_class); ?>">
                                    <td><span class="<?php echo e($span_class); ?>"><?php echo e($counter++); ?></span></td>
                                    <?php if($module_name_singular->data['data']['notification_type'] == 'new_subscription'): ?>
                                        <td>
                                            <span class="<?php echo e($span_class); ?>"><?php echo e(ucfirst($module_name_singular->data['data']['notification_group'])); ?></span>
                                        </td>
                                        <?php
                                            $notification = \Modules\NotificationTemplate\Models\NotificationTemplateContentMapping::where('subject', $module_name_singular->data['subject'])->first();
                                        ?>
                                        <td>

                                            
                                            <div class="d-flex gap-3 align-items-center">
                                                <div class="text-start">
                                                    <a href="#">
                                                        <h6><?php echo e($module_name_singular->data['subject']['name']); ?></h6>
                                                    </a>
                                                    
                                                </div>
                                            </div>
                                        </td>
                                        <?php
                                            $user = \App\Models\User::find($module_name_singular->data['data']['user_id']);
                                        ?>
                                        <td>
                                            <div class="d-flex gap-3 align-items-center">
                                                <img src="<?php echo e($user->profile_image ?? default_user_avatar()); ?>" alt="avatar" class="avatar avatar-40 rounded-pill">
                                                <div class="text-start">
                                                    <h6 class="m-0"><?php echo e($user->full_name ?? default_user_name()); ?></h6>
                                                    <span><?php echo e($user->email ?? '--'); ?></span>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($module_name_singular->updated_at->diffForHumans()); ?></td>
                                        <td>
                                            <a onclick="remove_notification()" id="delete-<?php echo e($module_name); ?>-<?php echo e($module_name_singular->id); ?>" class="fs-4 text-danger" data-type="ajax" data-method="DELETE" data-token="<?php echo e(csrf_token()); ?>" data-bs-toggle="tooltip" title="<?php echo e(__('Delete')); ?>" data-confirm="<?php echo e(__('messages.are_you_sure?')); ?>">
                                                <i class="ph ph-trash"></i>
                                            </a>
                                        </td>
                                    <?php else: ?>
                                        <td>
                                            <span class="<?php echo e($span_class); ?>"><?php echo e(ucwords(str_replace('_', ' ', $module_name_singular->data['data']['notification_group']))); ?></span>
                                        </td>
                                        <td>
                                            <div class="d-flex gap-3 align-items-center">
                                                <div class="text-start">
                                                    <a href="#">
                                                        <h6><?php echo e($module_name_singular->data['subject']); ?></h6>
                                                    </a>
                                                    <span class="font-weight-bold"> Your <?php echo e($module_name_singular->data['data']['service_name']); ?> account balance is insufficient. Please recharge your account to maintain service availability.</span>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex gap-3 align-items-center">
                                                <div class="text-start">
                                                    <h6 class="m-0"><?php echo e($module_name_singular->data['data']['user_name']); ?></h6>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($module_name_singular->updated_at->diffForHumans()); ?></td>
                                        <td>
                                            <a onclick="remove_notification()" id="delete-<?php echo e($module_name); ?>-<?php echo e($module_name_singular->id); ?>" class="fs-4 text-danger" data-type="ajax" data-method="DELETE" data-token="<?php echo e(csrf_token()); ?>" data-bs-toggle="tooltip" title="<?php echo e(__('Delete')); ?>" data-confirm="<?php echo e(__('messages.are_you_sure?')); ?>">
                                                <i class="ph ph-trash"></i>
                                            </a>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" style="text-align: center; vertical-align: middle;">
                                        <?php echo e(__('No data found')); ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('after-scripts'); ?>
    <script type="text/javascript" src="<?php echo e(asset('vendor/datatable/datatables.min.js')); ?>"></script>
    <script src="<?php echo e(mix('js/vue.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/form-offcanvas/index.js')); ?>" defer></script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/update/vizion-ai/vizion-ai/resources/views/backend/notifications/index.blade.php ENDPATH**/ ?>